<?php

use App\Enums\PatrollingStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patrolling_logs', function (Blueprint $table) {
            $table->id();

            $table->foreignId('location_id')->constrained('patrolling_locations')->onDelete('cascade');
            $table->foreignId('guard_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('daily_patrol_summary_id')->constrained('daily_patrol_summaries')->onDelete('cascade');

            $table->date('patrol_date');
            $table->timestamp('patrol_time')->nullable();
            $table->enum('status', PatrollingStatus::values())->default(PatrollingStatus::CHECKED->value);
            $table->text('notes')->nullable();
            $table->text('issues_found')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patrolling_logs');
    }
};
