<?php

namespace App\Http\Requests\PatrollingLog;

use App\Http\Requests\BaseRequest;
use App\Enums\PatrollingStatus;
use Illuminate\Validation\Rule;

class UpdatePatrollingLogRequest extends BaseRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'location_id' => ['sometimes', 'exists:patrolling_locations,id'],
            'guard_id' => ['sometimes', 'exists:guards,id'],
            'patrol_date' => ['sometimes', 'date'],
            'patrol_time' => ['sometimes', 'date_format:Y-m-d H:i'],
            'status' => ['sometimes', Rule::enum(PatrollingStatus::class)],
            'notes' => ['sometimes', 'nullable', 'string'],
            'issues_found' => ['sometimes', 'nullable', 'string'],
        ];
    }
}
