<?php

namespace App\Http\Controllers\Api;

use App\Enums\UserRole;
use App\Helpers\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Requests\Flat\StoreFlatRequest;
use App\Http\Requests\Flat\UpdateFlatRequest;
use App\Http\Resources\FlatResource;
use App\Models\Flat;
use Spatie\QueryBuilder\QueryBuilder;

class FlatController extends Controller
{
    public function index() {
        $query = QueryBuilder::for(Flat::class)
            ->allowedFilters(['wing_id', 'owner_id', 'flat_no', 'status'])
            ->allowedIncludes('wing', 'owner')
            ->latest();

        $user = auth()->guard('sanctum')->user();

        if ($user->role == UserRole::USER || $user->role == UserRole::OWNER) {
            $query->where('owner_id', $user->owner_id);
        }

        $flats = $query
            ->paginate(request("perPage", 15));

        return ApiResponse::paginated($flats);
    }

    public function store(StoreFlatRequest $request) {
        $flat = Flat::create($request->validated());

        return ApiResponse::created(
            new FlatResource($flat),
            "Flat has been created successfully!"
        );
    }

    public function show(Flat $flat) {
        return ApiResponse::resource(new FlatResource($flat));
    }

    public function update(UpdateFlatRequest $request, Flat $flat) {
        $flat->update($request->validated());

        return ApiResponse::updated(
            new FlatResource($flat),
            "Flat has been updated successfully!",
        );
    }

    public function destroy(Flat $flat) {
        $flat->delete();

        return ApiResponse::deleted("Flat deleted successfully!");
    }
}
