<?php

namespace App\Enums;

enum VisitorType: string
{
    case GUEST = "guest";
    case SERVICE_PROVIDER = "service_provider";
    case DELIVERY = "delivery";
    case CONTRACTOR = "contractor";
    case FAMILY = "family";
    case FRIEND = "friend";
    case OTHER = "other";

    /**
     * Get all visitor type values
     */
    public static function values(): array {
        return array_column(self::cases(), 'value');
    }
}