<?php

namespace App\Models;

use App\Enums\PatrollingLocationType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PatrollingLocation extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'type',
        'location_code',
        'description',
        'is_active',
        'wing_id',
        'coordinates',
    ];

    protected function casts(): array
    {
        return [
            'type' => PatrollingLocationType::class,
            'is_active' => 'boolean',
        ];
    }

    public function wing(): BelongsTo
    {
        return $this->belongsTo(Wing::class);
    }

    public function patrollingLogs(): HasMany
    {
        return $this->hasMany(PatrollingLog::class, 'location_id');
    }
}
