<?php //ffacb2a18884291affcc3ae2ddb95941
/** @noinspection all */

namespace App\Models {

    use App\Enums\DailyPatrolSummaryStatus;
    use App\Enums\Gender;
    use App\Enums\PatrollingLocationType;
    use App\Enums\PatrollingStatus;
    use App\Enums\UserRole;
    use App\Enums\VehicleLogType;
    use App\Enums\VehicleType;
    use App\Enums\VisitorStatus;
    use App\Enums\VisitorType;
    use Database\Factories\DailyPatrolSummaryFactory;
    use Database\Factories\FlatFactory;
    use Database\Factories\GuardFactory;
    use Database\Factories\OwnerFactory;
    use Database\Factories\PatrollingLocationFactory;
    use Database\Factories\PatrollingLogFactory;
    use Database\Factories\UserFactory;
    use Database\Factories\VehicleFactory;
    use Database\Factories\VehicleLogFactory;
    use Database\Factories\VisitorFactory;
    use Database\Factories\WingFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOneThrough;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Laravel\Sanctum\PersonalAccessToken;
    use LaravelIdea\Helper\App\Models\_IH_DailyPatrolSummary_C;
    use LaravelIdea\Helper\App\Models\_IH_DailyPatrolSummary_QB;
    use LaravelIdea\Helper\App\Models\_IH_Flat_C;
    use LaravelIdea\Helper\App\Models\_IH_Flat_QB;
    use LaravelIdea\Helper\App\Models\_IH_Guard_C;
    use LaravelIdea\Helper\App\Models\_IH_Guard_QB;
    use LaravelIdea\Helper\App\Models\_IH_Owner_C;
    use LaravelIdea\Helper\App\Models\_IH_Owner_QB;
    use LaravelIdea\Helper\App\Models\_IH_PatrollingLocation_C;
    use LaravelIdea\Helper\App\Models\_IH_PatrollingLocation_QB;
    use LaravelIdea\Helper\App\Models\_IH_PatrollingLog_C;
    use LaravelIdea\Helper\App\Models\_IH_PatrollingLog_QB;
    use LaravelIdea\Helper\App\Models\_IH_PatrolRound_C;
    use LaravelIdea\Helper\App\Models\_IH_PatrolRound_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\App\Models\_IH_VehicleLog_C;
    use LaravelIdea\Helper\App\Models\_IH_VehicleLog_QB;
    use LaravelIdea\Helper\App\Models\_IH_Vehicle_C;
    use LaravelIdea\Helper\App\Models\_IH_Vehicle_QB;
    use LaravelIdea\Helper\App\Models\_IH_Visitor_C;
    use LaravelIdea\Helper\App\Models\_IH_Visitor_QB;
    use LaravelIdea\Helper\App\Models\_IH_Wing_C;
    use LaravelIdea\Helper\App\Models\_IH_Wing_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_C;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_QB;
    
    /**
     * @property int $id
     * @property int $guard_id
     * @property Carbon $patrol_date
     * @property int $total_locations
     * @property int $completed_locations
     * @property int $missed_locations
     * @property DailyPatrolSummaryStatus $status
     * @property string|null $notes
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $patrol_round_id
     * @property Carbon $expected_start_time
     * @property Carbon $expected_end_time
     * @property Carbon|null $actual_start_time
     * @property Carbon|null $actual_end_time
     * @property-read null|string $actual_duration attribute
     * @property-read float $completion_percentage attribute
     * @property-read null|string $expected_duration attribute
     * @property-read bool $is_delayed attribute
     * @property-read bool $is_on_time attribute
     * @property Guard $guardUser
     * @method BelongsTo|_IH_Guard_QB guardUser()
     * @property PatrolRound $patrolRound
     * @method BelongsTo|_IH_PatrolRound_QB patrolRound()
     * @property _IH_PatrollingLog_C|PatrollingLog[] $patrollingLogs
     * @property-read int $patrolling_logs_count
     * @method HasMany|_IH_PatrollingLog_QB patrollingLogs()
     * @method static _IH_DailyPatrolSummary_QB onWriteConnection()
     * @method _IH_DailyPatrolSummary_QB newQuery()
     * @method static _IH_DailyPatrolSummary_QB on(null|string $connection = null)
     * @method static _IH_DailyPatrolSummary_QB query()
     * @method static _IH_DailyPatrolSummary_QB with(array|string $relations)
     * @method _IH_DailyPatrolSummary_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DailyPatrolSummary_C|DailyPatrolSummary[] all()
     * @ownLinks guard_id,\App\Models\Guard,id|patrol_round_id,\App\Models\PatrolRound,id
     * @foreignLinks id,\App\Models\PatrollingLog,daily_patrol_summary_id
     * @mixin _IH_DailyPatrolSummary_QB
     * @method static DailyPatrolSummaryFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class DailyPatrolSummary extends Model {}
    
    /**
     * @property int $id
     * @property int $wing_id
     * @property int|null $owner_id
     * @property string $flat_no
     * @property string $status
     * @property float $flat_sqrft
     * @property string|null $agreement
     * @property string|null $other_docs
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Owner|null $owner
     * @method BelongsTo|_IH_Owner_QB owner()
     * @property Wing $wing
     * @method BelongsTo|_IH_Wing_QB wing()
     * @method static _IH_Flat_QB onWriteConnection()
     * @method _IH_Flat_QB newQuery()
     * @method static _IH_Flat_QB on(null|string $connection = null)
     * @method static _IH_Flat_QB query()
     * @method static _IH_Flat_QB with(array|string $relations)
     * @method _IH_Flat_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Flat_C|Flat[] all()
     * @ownLinks wing_id,\App\Models\Wing,id|owner_id,\App\Models\Owner,id
     * @foreignLinks id,\App\Models\User,flat_id|id,\App\Models\Vehicle,flat_id|id,\App\Models\Visitor,flat_id
     * @mixin _IH_Flat_QB
     * @method static FlatFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class Flat extends Model {}
    
    /**
     * @property int $id
     * @property int|null $wing_id
     * @property string $name
     * @property string $email
     * @property string $phone
     * @property string $role
     * @property string $gender
     * @property string|null $photo
     * @property string|null $agreement
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Wing|null $wing
     * @method BelongsTo|_IH_Wing_QB wing()
     * @method static _IH_Guard_QB onWriteConnection()
     * @method _IH_Guard_QB newQuery()
     * @method static _IH_Guard_QB on(null|string $connection = null)
     * @method static _IH_Guard_QB query()
     * @method static _IH_Guard_QB with(array|string $relations)
     * @method _IH_Guard_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Guard_C|Guard[] all()
     * @ownLinks wing_id,\App\Models\Wing,id
     * @foreignLinks id,\App\Models\VehicleLog,guard_id|id,\App\Models\PatrollingLog,guard_id|id,\App\Models\DailyPatrolSummary,guard_id|id,\App\Models\Visitor,checked_in_by|id,\App\Models\Visitor,checked_out_by
     * @mixin _IH_Guard_QB
     * @method static GuardFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class Guard extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property string $phone
     * @property string $aadhaar_no
     * @property string $pan_no
     * @property string|null $aadhaar_card
     * @property string|null $pan_card
     * @property string|null $photo
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Flat_C|Flat[] $flats
     * @property-read int $flats_count
     * @method HasMany|_IH_Flat_QB flats()
     * @method static _IH_Owner_QB onWriteConnection()
     * @method _IH_Owner_QB newQuery()
     * @method static _IH_Owner_QB on(null|string $connection = null)
     * @method static _IH_Owner_QB query()
     * @method static _IH_Owner_QB with(array|string $relations)
     * @method _IH_Owner_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Owner_C|Owner[] all()
     * @foreignLinks id,\App\Models\Flat,owner_id|id,\App\Models\User,owner_id|id,\App\Models\Vehicle,owner_id
     * @mixin _IH_Owner_QB
     * @method static OwnerFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class Owner extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property Carbon $start_time
     * @property Carbon $end_time
     * @property bool $is_active
     * @property string|null $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $duration attribute
     * @property _IH_DailyPatrolSummary_C|DailyPatrolSummary[] $dailyPatrolSummaries
     * @property-read int $daily_patrol_summaries_count
     * @method HasMany|_IH_DailyPatrolSummary_QB dailyPatrolSummaries()
     * @method static _IH_PatrolRound_QB onWriteConnection()
     * @method _IH_PatrolRound_QB newQuery()
     * @method static _IH_PatrolRound_QB on(null|string $connection = null)
     * @method static _IH_PatrolRound_QB query()
     * @method static _IH_PatrolRound_QB with(array|string $relations)
     * @method _IH_PatrolRound_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PatrolRound_C|PatrolRound[] all()
     * @foreignLinks id,\App\Models\DailyPatrolSummary,patrol_round_id
     * @mixin _IH_PatrolRound_QB
     */
    class PatrolRound extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property PatrollingLocationType $type
     * @property string $location_code
     * @property string|null $description
     * @property bool $is_active
     * @property int|null $wing_id
     * @property string|null $coordinates
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_PatrollingLog_C|PatrollingLog[] $patrollingLogs
     * @property-read int $patrolling_logs_count
     * @method HasMany|_IH_PatrollingLog_QB patrollingLogs()
     * @property Wing|null $wing
     * @method BelongsTo|_IH_Wing_QB wing()
     * @method static _IH_PatrollingLocation_QB onWriteConnection()
     * @method _IH_PatrollingLocation_QB newQuery()
     * @method static _IH_PatrollingLocation_QB on(null|string $connection = null)
     * @method static _IH_PatrollingLocation_QB query()
     * @method static _IH_PatrollingLocation_QB with(array|string $relations)
     * @method _IH_PatrollingLocation_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PatrollingLocation_C|PatrollingLocation[] all()
     * @ownLinks wing_id,\App\Models\Wing,id
     * @foreignLinks id,\App\Models\PatrollingLog,location_id
     * @mixin _IH_PatrollingLocation_QB
     * @method static PatrollingLocationFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class PatrollingLocation extends Model {}
    
    /**
     * @property int $id
     * @property int $location_id
     * @property int $guard_id
     * @property Carbon $patrol_date
     * @property Carbon|null $patrol_time
     * @property PatrollingStatus $status
     * @property string|null $notes
     * @property string|null $issues_found
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $daily_patrol_summary_id
     * @property DailyPatrolSummary $dailyPatrolSummary
     * @method BelongsTo|_IH_DailyPatrolSummary_QB dailyPatrolSummary()
     * @property Guard $guardUser
     * @method BelongsTo|_IH_Guard_QB guardUser()
     * @property PatrollingLocation $location
     * @method BelongsTo|_IH_PatrollingLocation_QB location()
     * @property PatrolRound $patrolRound
     * @method HasOneThrough|_IH_PatrolRound_QB patrolRound()
     * @method static _IH_PatrollingLog_QB onWriteConnection()
     * @method _IH_PatrollingLog_QB newQuery()
     * @method static _IH_PatrollingLog_QB on(null|string $connection = null)
     * @method static _IH_PatrollingLog_QB query()
     * @method static _IH_PatrollingLog_QB with(array|string $relations)
     * @method _IH_PatrollingLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PatrollingLog_C|PatrollingLog[] all()
     * @ownLinks location_id,\App\Models\PatrollingLocation,id|guard_id,\App\Models\Guard,id|daily_patrol_summary_id,\App\Models\DailyPatrolSummary,id
     * @mixin _IH_PatrollingLog_QB
     * @method static PatrollingLogFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class PatrollingLog extends Model {}
    
    /**
     * @property int $id
     * @property int|null $owner_id
     * @property int|null $flat_id
     * @property string $name
     * @property string $email
     * @property string $phone
     * @property mixed $password
     * @property UserRole $role
     * @property Gender $gender
     * @property string|null $relation
     * @property Carbon|null $email_verified_at
     * @property string|null $photo
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Flat|null $flat
     * @method BelongsTo|_IH_Flat_QB flat()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property Owner|null $owner
     * @method BelongsTo|_IH_Owner_QB owner()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @ownLinks owner_id,\App\Models\Owner,id|flat_id,\App\Models\Flat,id
     * @foreignLinks id,\App\Models\Visitor,approved_by
     * @mixin _IH_User_QB
     * @method static UserFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class User extends Model {}
    
    /**
     * @property int $id
     * @property int $owner_id
     * @property int $flat_id
     * @property VehicleType $vehicle_type
     * @property string $make
     * @property string $model
     * @property string $color
     * @property string $registration_no
     * @property string $unique_code
     * @property string|null $photo
     * @property string|null $insurance_doc
     * @property bool $is_active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Flat $flat
     * @method BelongsTo|_IH_Flat_QB flat()
     * @property Owner $owner
     * @method BelongsTo|_IH_Owner_QB owner()
     * @property _IH_VehicleLog_C|VehicleLog[] $vehicleLogs
     * @property-read int $vehicle_logs_count
     * @method HasMany|_IH_VehicleLog_QB vehicleLogs()
     * @method static _IH_Vehicle_QB onWriteConnection()
     * @method _IH_Vehicle_QB newQuery()
     * @method static _IH_Vehicle_QB on(null|string $connection = null)
     * @method static _IH_Vehicle_QB query()
     * @method static _IH_Vehicle_QB with(array|string $relations)
     * @method _IH_Vehicle_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Vehicle_C|Vehicle[] all()
     * @ownLinks owner_id,\App\Models\Owner,id|flat_id,\App\Models\Flat,id
     * @foreignLinks id,\App\Models\VehicleLog,vehicle_id
     * @mixin _IH_Vehicle_QB
     * @method static VehicleFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class Vehicle extends Model {}
    
    /**
     * @property int $id
     * @property int|null $vehicle_id
     * @property int $guard_id
     * @property VehicleLogType $entry_type
     * @property Carbon $entry_time
     * @property Carbon|null $exit_time
     * @property string|null $purpose
     * @property array|null $visitor_details
     * @property array|null $outsider_vehicle_details
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Guard $guardUser
     * @method BelongsTo|_IH_Guard_QB guardUser()
     * @property Vehicle|null $vehicle
     * @method BelongsTo|_IH_Vehicle_QB vehicle()
     * @method static _IH_VehicleLog_QB onWriteConnection()
     * @method _IH_VehicleLog_QB newQuery()
     * @method static _IH_VehicleLog_QB on(null|string $connection = null)
     * @method static _IH_VehicleLog_QB query()
     * @method static _IH_VehicleLog_QB with(array|string $relations)
     * @method _IH_VehicleLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_VehicleLog_C|VehicleLog[] all()
     * @ownLinks vehicle_id,\App\Models\Vehicle,id|guard_id,\App\Models\Guard,id
     * @mixin _IH_VehicleLog_QB
     * @method static VehicleLogFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class VehicleLog extends Model {}
    
    /**
     * @property int $id
     * @property int $wing_id
     * @property int $flat_id
     * @property int|null $approved_by
     * @property int|null $checked_in_by
     * @property int|null $checked_out_by
     * @property string $name
     * @property string $phone
     * @property string|null $email
     * @property VisitorType $visitor_type
     * @property string $purpose
     * @property string|null $photo
     * @property VisitorStatus $status
     * @property Carbon|null $entry_time
     * @property Carbon|null $exit_time
     * @property Carbon|null $approved_at
     * @property string|null $approval_notes
     * @property string|null $rejection_reason
     * @property array|null $additional_info
     * @property bool $is_recurring
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $approvedBy
     * @method BelongsTo|_IH_User_QB approvedBy()
     * @property Guard|null $checkedInBy
     * @method BelongsTo|_IH_Guard_QB checkedInBy()
     * @property Guard|null $checkedOutBy
     * @method BelongsTo|_IH_Guard_QB checkedOutBy()
     * @property Flat $flat
     * @method BelongsTo|_IH_Flat_QB flat()
     * @property Wing $wing
     * @method BelongsTo|_IH_Wing_QB wing()
     * @method static _IH_Visitor_QB onWriteConnection()
     * @method _IH_Visitor_QB newQuery()
     * @method static _IH_Visitor_QB on(null|string $connection = null)
     * @method static _IH_Visitor_QB query()
     * @method static _IH_Visitor_QB with(array|string $relations)
     * @method _IH_Visitor_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Visitor_C|Visitor[] all()
     * @ownLinks wing_id,\App\Models\Wing,id|flat_id,\App\Models\Flat,id|approved_by,\App\Models\User,id|checked_in_by,\App\Models\Guard,id|checked_out_by,\App\Models\Guard,id
     * @mixin _IH_Visitor_QB
     * @method static VisitorFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class Visitor extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property int $no_floors
     * @property int $no_flats
     * @property int $no_lifts
     * @property Carbon|null $fire_extinguisher_date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Wing_QB onWriteConnection()
     * @method _IH_Wing_QB newQuery()
     * @method static _IH_Wing_QB on(null|string $connection = null)
     * @method static _IH_Wing_QB query()
     * @method static _IH_Wing_QB with(array|string $relations)
     * @method _IH_Wing_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Wing_C|Wing[] all()
     * @foreignLinks id,\App\Models\Flat,wing_id|id,\App\Models\Guard,wing_id|id,\App\Models\PatrollingLocation,wing_id|id,\App\Models\Visitor,wing_id
     * @mixin _IH_Wing_QB
     * @method static WingFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class Wing extends Model {}
}