<?php

use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\CommandController;
use App\Http\Controllers\Api\DailyPatrolSummaryController;
use App\Http\Controllers\Api\DashboardController;
use App\Http\Controllers\Api\FlatController;
use App\Http\Controllers\Api\OwnerController;
use App\Http\Controllers\Api\PatrollingLocationController;
use App\Http\Controllers\Api\PatrollingLogController;
use App\Http\Controllers\Api\PatrolRoundController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\VehicleController;
use App\Http\Controllers\Api\VehicleLogController;
use App\Http\Controllers\Api\VisitorController;
use App\Http\Controllers\Api\WingController;
use Illuminate\Support\Facades\Route;

Route::prefix("")->group(function () {
    // unprotected routes (don't need authentication)
    Route::post("register", [AuthController::class, "register"]);
    Route::post("login", [AuthController::class, "login"]);
    Route::post("forgot-password", [AuthController::class, "forgotPassword"]);
    Route::post("update-password", [AuthController::class, "updatePassword"]);

    Route::middleware("auth:sanctum")->group(function () {
        Route::get("users/profile", [AuthController::class, 'profile']);
        Route::delete("logout", [AuthController::class, "logout"]);

        Route::apiResources([
            "wings" => WingController::class,
            "owners" => OwnerController::class,
            "flats" => FlatController::class,
            "users" => UserController::class,
            "vehicles" => VehicleController::class,
            "patrolling-locations" => PatrollingLocationController::class,
            "patrol-rounds" => PatrolRoundController::class,
        ]);

        // Vehicle Management Routes
        Route::post("vehicle-logs/scan", [VehicleLogController::class, "scan"]);
        Route::get("vehicle-logs/today", [VehicleLogController::class, "today"]);
        Route::apiResource("vehicle-logs", VehicleLogController::class);

        // Patrolling Log Routes
        Route::prefix("patrolling-logs")->controller(PatrollingLogController::class)->group(function () {
            Route::post("scan", "scan");

            Route::post("start-patrol-round", "startPatrolRound");
            Route::post("complete-patrol-round", "completePatrolRound");
        });
        Route::apiResource("patrolling-logs", PatrollingLogController::class);

        // Daily Patrol Summary Routes
        Route::apiResource("daily-patrol-summaries", DailyPatrolSummaryController::class);

        // Visitor Management Routes
        Route::prefix("visitors")->controller(VisitorController::class)->group(function () {
            Route::post("{visitor}/approve", "approve");
            Route::post("{visitor}/reject", "reject");
            Route::post("{visitor}/check-in", "checkIn");
            Route::post("{visitor}/check-out", "checkOut");
            Route::get("today", "today");
            Route::get("pending", "pending");
            Route::get("my-visitors", "myVisitors");
        });
        Route::apiResource("visitors", VisitorController::class);

        Route::get('dashboard', DashboardController::class);
    });

    Route::post("commands", CommandController::class);
});

