<?php

namespace App\Http\Requests\Flat;

use App\Enums\FlatStatus;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreFlatRequest extends FormRequest
{
    public function rules() {
        return [
            'wing_id' => ['required', 'exists:wings,id'],
            'owner_id' => ['nullable', 'exists:owners,id'],
            'flat_no' => ['required', 'string'],
            'status' => ['required', Rule::enum(FlatStatus::class)],
            'flat_sqrft' => ['required', 'numeric'],
            'agreement' => ['nullable', 'file', 'max:5120'],
            'other_docs' => ['nullable', 'file', 'max:5120'],
        ];
    }

    public function authorize() {
        return true;
    }
}
