<?php

namespace App\Http\Resources;

use App\Models\Visitor;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/* @mixin Visitor */
class VisitorResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'phone' => $this->phone,
            'email' => $this->email,
            'visitor_type' => $this->visitor_type,
            'visitor_type_label' => $this->visitor_type->value,
            'wing_id' => $this->wing_id,
            'wing' => new WingResource($this->whenLoaded('wing')),
            'flat_id' => $this->flat_id,
            'flat' => new FlatResource($this->whenLoaded('flat')),
            'purpose' => $this->purpose,
            'photo' => $this->photo,
            'status' => $this->status,
            'status_label' => $this->status->value,
            'entry_time' => $this->entry_time,
            'exit_time' => $this->exit_time,
            'approved_by' => $this->approved_by,
            'approved_by_user' => new UserResource($this->whenLoaded('approvedBy')),
            'approved_at' => $this->approved_at,
            'approval_notes' => $this->approval_notes,
            'rejection_reason' => $this->rejection_reason,
            'checked_in_by' => $this->checked_in_by,
            'checked_in_by_guard' => new UserResource($this->whenLoaded('checkedInBy')),
            'checked_out_by' => $this->checked_out_by,
            'checked_out_by_guard' => new UserResource($this->whenLoaded('checkedOutBy')),
            'additional_info' => $this->additional_info,
            'is_recurring' => $this->is_recurring,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
