<?php

namespace App\Models;

use App\Enums\VehicleLogType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VehicleLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'vehicle_id',
        'guard_id',
        'log_type',
        'logged_at',
        'purpose',
        'visitor_details',
        'outsider_vehicle_details',
    ];

    protected function casts(): array
    {
        return [
            'log_type' => VehicleLogType::class,
            'logged_at' => 'datetime',
            'visitor_details' => 'array',
            'outsider_vehicle_details' => 'array',
        ];
    }

    public function vehicle(): BelongsTo
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function guardUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'guard_id');
    }
}
