<?php

namespace App\Http\Requests\User;

use App\Enums\Gender;
use App\Enums\UserRole;
use App\Http\Requests\BaseRequest;
use Illuminate\Validation\Rule;

class UpdateUserRequest extends BaseRequest
{
    public function rules() {
        $user = $this->route("user");

        return [
            'owner_id' => ['nullable', 'exists:owners,id'],
            'flat_id' => ['nullable', 'exists:flats,id'],
            'name' => ['sometimes'],
            'email' => [
                'sometimes', 'email', 'max:254',
                Rule::unique('users', 'email')->ignore($user)
            ],
            'phone' => ['sometimes', 'string'],
            'password' => ['sometimes', 'string', 'confirmed'],
            'role' => ['sometimes', Rule::enum(UserRole::class)],
            'gender' => ['sometimes', Rule::enum(Gender::class)],
            'relation' => ['nullable', 'string'],
            'photo' => $this->validateFile("photo"),
        ];
    }

    public function authorize() {
        return true;
    }
}
