<?php

namespace App\Http\Requests\Owner;

use App\Http\Requests\BaseRequest;
use Illuminate\Validation\Rule;

class UpdateOwnerRequest extends BaseRequest
{
    public function rules(): array {
        $owner = $this->route('owner');

        return [
            'name' => ['sometimes', 'string'],
            'email' => [
                'sometimes', 'email', 'max:254',
                Rule::unique('owners', 'email')->ignore($owner)
            ],
            'phone' => ['sometimes'],
            'aadhaar_no' => [
                'sometimes', 'string', 'max:254',
                Rule::unique('owners', 'aadhaar_no')->ignore($owner)
            ],
            'pan_no' => [
                'sometimes', 'string', 'max:254',
                Rule::unique('owners', 'pan_no')->ignore($owner)
            ],

            'aadhaar_card' => $this->validateFile('aadhaar_card'),
            'pan_card' => $this->validateFile('pan_card'),
            'photo' => $this->validateFile('photo'),
        ];
    }


    public function authorize() {
        return true;
    }
}
