<?php

namespace App\Http\Controllers\Api;

use App\Helpers\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Requests\Wing\StoreWingRequest;
use App\Http\Requests\Wing\UpdateWingRequest;
use App\Http\Resources\WingResource;
use App\Models\Wing;
use Spatie\QueryBuilder\QueryBuilder;

class WingController extends Controller
{
    public function index() {
        $query = QueryBuilder::for(Wing::class)
            ->allowedFilters(['name'])
            ->latest();

        $wings = $query
            ->paginate(request("perPage", 15));

        return ApiResponse::paginated($wings);
    }

    public function store(StoreWingRequest $request) {
        $wing = Wing::create($request->validated());

        return ApiResponse::created(
            new WingResource($wing),
            "Wing has been created successfully!"
        );
    }

    public function show(Wing $wing) {
        return ApiResponse::resource(new WingResource($wing));
    }

    public function update(UpdateWingRequest $request, Wing $wing) {
        $wing->update($request->validated());

        return ApiResponse::updated(
            new WingResource($wing),
            "Wing has been updated successfully!",
        );
    }

    public function destroy(Wing $wing) {
        $wing->delete();

        return ApiResponse::deleted("Wing deleted successfully!");
    }
}
